<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Headers
header("Access-Control-Allow-Origin: *");
header("Content-Type: text/html; charset=UTF-8");

// Database connection
class Database {
    private $host = "localhost";
    private $database_name = "ed5_school_management";
    private $username = "ed5_test";
    private $password = "Goal2020$#@";
    private $conn;

    public function getConnection() {
        $this->conn = null;
        try {
            $this->conn = new PDO(
                "mysql:host=" . $this->host . ";dbname=" . $this->database_name, 
                $this->username, 
                $this->password
            );
            $this->conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            return $this->conn;
        } catch(PDOException $e) {
            die("Connection Error: " . $e->getMessage());
        }
    }
}

function validateToken($token, $db) {
    try {
        $query = "SELECT id, username FROM users WHERE remember_token = :token";
        $stmt = $db->prepare($query);
        $stmt->bindParam(":token", $token);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    } catch(PDOException $e) {
        return false;
    }
}

// Initialize database
$database = new Database();
$db = $database->getConnection();

// Get test token from POST or Authorization header
$test_token = null;
$validation_result = null;
$headers = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['token'])) {
    $test_token = trim($_POST['token']);
    $validation_result = validateToken($test_token, $db);
} else {
    $headers = getallheaders();
    if (isset($headers['Authorization'])) {
        $test_token = trim(str_replace('Bearer ', '', $headers['Authorization']));
        $validation_result = validateToken($test_token, $db);
    }
}

// Get all valid tokens from database
$query = "SELECT id, username, remember_token FROM users WHERE remember_token IS NOT NULL";
$stmt = $db->prepare($query);
$stmt->execute();
$all_tokens = $stmt->fetchAll(PDO::FETCH_ASSOC);

?>
<!DOCTYPE html>
<html>
<head>
    <title>Token Validation Test</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .container { max-width: 800px; margin: 0 auto; }
        .section { margin-bottom: 20px; padding: 10px; border: 1px solid #ccc; }
        .success { color: green; }
        .error { color: red; }
        pre { background: #f5f5f5; padding: 10px; overflow-x: auto; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Token Validation Test</h1>

        <!-- Token Test Form -->
        <div class="section">
            <h2>Test Token Validation</h2>
            <form method="POST">
                <input type="text" name="token" size="80" value="<?php echo htmlspecialchars($test_token ?? ''); ?>" placeholder="Enter token to test">
                <input type="submit" value="Validate Token">
            </form>
        </div>

        <!-- Token Validation Results -->
        <?php if ($test_token): ?>
        <div class="section">
            <h2>Validation Results</h2>
            <?php if ($validation_result): ?>
                <p class="success">✓ Token is valid!</p>
                <pre><?php echo json_encode($validation_result, JSON_PRETTY_PRINT); ?></pre>
            <?php else: ?>
                <p class="error">✗ Token is invalid!</p>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <!-- Headers Received -->
        <div class="section">
            <h2>Headers Received</h2>
            <pre><?php echo json_encode($headers, JSON_PRETTY_PRINT); ?></pre>
        </div>

        <!-- Valid Tokens in Database -->
        <div class="section">
            <h2>Valid Tokens in Database</h2>
            <pre><?php echo json_encode($all_tokens, JSON_PRETTY_PRINT); ?></pre>
        </div>
    </div>
</body>
</html>