$(document).ready(function() {
    // Show loading spinner
    const loadingSpinner = $("#loadingSpinner");
    loadingSpinner.css("display", "flex");
    
    // Hide spinner after content loads
    setTimeout(function() {
        loadingSpinner.fadeOut(300);
        
        // Initialize animated elements
        animateCards();
        animateTimelineItems();
        initProgressBars();
        
        // Initialize charts
        initAttendanceChart();
        initFeeChart();
        initPerformanceChart();
        initPaymentTimelineChart();
    }, 800);
    
    // Tab functionality
    $(".tab-link").on("click", function() {
        const tabId = $(this).data("tab");
        
        // Update active tab
        $(".tab-link").removeClass("active");
        $(this).addClass("active");
        
        // Update tab indicator position
        const position = $(this).position().left;
        const width = $(this).outerWidth();
        $(".tab-indicator").css({
            left: position + "px",
            width: width + "px"
        });
        
        // Show active tab content
        $(".tab-content").removeClass("active");
        $("#" + tabId).addClass("active");
        
        // Initialize cards animation for the tab
        animateCards();
        animateTimelineItems();
    });
    
    // Initialize tab indicator position
    const $activeTab = $(".tab-link.active");
    const position = $activeTab.position().left;
    const width = $activeTab.outerWidth();
    $(".tab-indicator").css({
        left: position + "px",
        width: width + "px"
    });
    
    // Bottom navbar functionality
    $(".nav-item").on("click", function() {
        $(".nav-item").removeClass("active");
        $(this).addClass("active");
    });
    
    // Card animation on scroll
    function animateCards() {
        $(".info-card").each(function(index) {
            const card = $(this);
            setTimeout(function() {
                card.addClass("animate");
            }, 100 * index);
        });
    }
    
    // Timeline items animation
    function animateTimelineItems() {
        $(".timeline-item").each(function(index) {
            const item = $(this);
            setTimeout(function() {
                item.addClass("animate");
            }, 150 * index);
        });
    }
    
    // Initialize progress bars
    function initProgressBars() {
        $("#feeProgressBar").each(function() {
            const percent = $(this).data("percent");
            $(this).css("width", "0%");
            
            setTimeout(() => {
                $(this).css("width", percent + "%");
            }, 300);
        });
    }
    
    // Initialize attendance donut chart
    function initAttendanceChart() {
        const ctx = document.createElement("canvas");
        $("#attendanceDonutChart").prepend(ctx);
        
        const attendancePercent = parseFloat($(".attendance-percent").text()) || 0;
        
        new Chart(ctx, {
            type: 'doughnut',
            data: {
                datasets: [{
                    data: [attendancePercent, 100 - attendancePercent],
                    backgroundColor: [
                        'rgb(65, 88, 208)',
                        'rgb(240, 242, 245)'
                    ],
                    borderWidth: 0,
                    cutout: '75%'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    },
                    tooltip: {
                        enabled: false
                    }
                },
                animation: {
                    animateRotate: true,
                    animateScale: true
                }
            }
        });
    }
    
    // Initialize fee chart
    function initFeeChart() {
        const ctx = document.createElement("canvas");
        $("#feeChart").append(ctx);
        
        // Sample data for fee breakdown
        const data = {
            labels: ['Tuition Fee', 'Activity Fee', 'Transport Fee', 'Library Fee', 'Other Fees'],
            datasets: [{
                label: 'Fee Breakdown',
                data: [70, 10, 10, 5, 5],
                backgroundColor: [
                    'rgba(65, 88, 208, 0.8)',
                    'rgba(200, 80, 192, 0.8)',
                    'rgba(255, 204, 112, 0.8)',
                    'rgba(75, 192, 192, 0.8)',
                    'rgba(153, 102, 255, 0.8)'
                ],
                borderWidth: 0
            }]
        };
        
        new Chart(ctx, {
            type: 'pie',
            data: data,
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'right',
                        labels: {
                            font: {
                                size: 10
                            },
                            boxWidth: 12
                        }
                    }
                }
            }
        });
    }
    
    // Initialize performance chart
    function initPerformanceChart() {
        const ctx = document.createElement("canvas");
        $("#performanceChart").html('').append(ctx);
        
        // Sample data for academic performance
        const data = {
            labels: ['Term 1', 'Term 2', 'Term 3', 'Final'],
            datasets: [{
                label: 'Marks',
                data: [78, 82, 85, 88],
                borderColor: 'rgb(65, 88, 208)',
                backgroundColor: 'rgba(65, 88, 208, 0.1)',
                tension: 0.3,
                fill: true
            }]
        };
        
        new Chart(ctx, {
            type: 'line',
            data: data,
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        max: 100
                    }
                },
                plugins: {
                    legend: {
                        display: false
                    }
                }
            }
        });
    }
    
    // Initialize payment timeline chart
    function initPaymentTimelineChart() {
        const ctx = document.createElement("canvas");
        $("#paymentTimelineChart").html('').append(ctx);
        
        // Sample data for payment timeline
        const data = {
            labels: ['Term 1', 'Term 2', 'Term 3'],
            datasets: [{
                label: 'Amount Paid',
                data: [8100, 6600, 0],
                backgroundColor: [
                    'rgba(65, 88, 208, 0.8)',
                    'rgba(200, 80, 192, 0.8)',
                    'rgba(255, 99, 132, 0.8)'
                ],
                borderWidth: 0
            }]
        };
        
        new Chart(ctx, {
            type: 'bar',
            data: data,
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    }
    
    // Initialize monthly attendance chart
    function initMonthlyAttendanceChart() {
        const ctx = document.createElement("canvas");
        $("#monthlyAttendanceChart").html('').append(ctx);
        
        // Sample data for monthly attendance
        const data = {
            labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
            datasets: [{
                label: 'Attendance (%)',
                data: [95, 92, 88, 94, 90, 93],
                backgroundColor: 'rgba(65, 88, 208, 0.8)',
                borderWidth: 0,
                borderRadius: 5
            }]
        };
        
        new Chart(ctx, {
            type: 'bar',
            data: data,
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        max: 100
                    }
                }
            }
        });
    }
    
    // Call initialization for the monthly attendance chart
    initMonthlyAttendanceChart();
    
    // Add click handlers to interactive elements
    $(".back-btn").on("click", function() {
        alert("Going back to the previous page");
    });
    
    $(".notification-icon").on("click", function() {
        alert("Notifications panel would open here");
    });
    
    $(".btn").on("click", function(e) {
        e.preventDefault();
        const action = $(this).text().trim();
        alert("Action: " + action);
    });
});